// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "Check.h"
#include "sha2.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	HHOOK		hHook;
extern	HWND		hMainWindow;
extern	HHOOK		hMouseHook;
extern	LPCTSTR		lpIconPointer;
extern	LPCTSTR		lpszAppName;
extern	LPCTSTR		lpszNullString;
extern	LPTSTR		lpszNA;
extern	HINSTANCE	hInst;
extern	HWND		hDlgModeLess1;
extern	HWND		hDlgCurrent;
extern	TCHAR		szPublicRingKeyId[MAX_PATH];
extern	TCHAR		szPublicRingUserId[MAX_PATH];
extern	TCHAR		szSecretRingKeyId[MAX_PATH];
extern	TCHAR		szSecretRingUserId[MAX_PATH];
extern	TCHAR		szBackUpFile[MAX_PATH];
extern	HANDLE		hPublicKeyRing;
extern	HANDLE		hPublicRingKeyId;
extern	HANDLE		hPublicRingUserId;
extern	HANDLE		hSecretKeyRing;
extern	HANDLE		hSecretRingKeyId;
extern	HANDLE		hSecretRingUserId;
extern	HANDLE		hBackUpFile;
extern	BOOL		bEnableMenuItems;
extern	DWORD		dwKeyRingFilesActive;
extern	LPBYTE		lpKeyBuffer1;
extern	LPBYTE		lpKeyBuffer2;
extern	LPBYTE		lpKeyBuffer3;
extern	BOOL		bProcessInProgress;
extern	DWORD		dwValidityPeriod;
extern	MD5_CTX		Md5Context;
extern	BOOL		bKeyRingFilesLoaded;
extern	DWORD		dwSecretDeleted;
extern	DWORD		dwPublicDeleted;
extern	BYTE		KeySID;
extern	DWORD		dwN_Bytes;
extern	DWORD		dwP_Bytes;
extern	DWORD		dwQ_Bytes;
extern	DWORD		dwP_Dwords;
extern	DWORD		dwQ_Dwords;
extern	DWORD		dwCountDwords;
extern	DWORD		dwCountBytes;
extern	DWORD		dwIdxOffset1;
extern	DWORD		dwIdxSize1;
extern	TCHAR		szPassPhrase1[250];
extern	int			iLengthOfPassPhrase;
extern	SEARCH_TEMPLATE		KeyIdSearch;
extern	LPBYTE		lpIndexFile2;
extern	HANDLE		hIdxHandle2;
extern	DWORD		dwIdxOffset2;
extern	LPVOID		lpIdxBuffer1;
extern	BOOL		bDisplayRingsOnStatusBar;
extern	TCHAR		szStatusBarRings[127];
extern	HCURSOR		hCursorWait;
extern	BYTE		ShaDigest;
extern	SHACONTEXT	ShaContext;
extern	sha512_ctx	Sha512Context;
extern	BYTE		Sha512Digest;
extern	LPBYTE		lpKeyBufferDup2;
extern	LPBYTE		lpKeyBufferDup1;
extern	TCHAR		szTemp[MAX_PATH];
extern	CONFIG		cfg;

// RSA variables.
//...............
extern	BYTE		Prime_P;
extern	BYTE		Prime_Q;
extern	BYTE		Modulus_N;
extern	BYTE		Temp1;
extern	BYTE		Temp2;
extern	BYTE		E_Temp;

// Local definitions.
//...................
#define	CHECK_LOADED	1
#define	CHECK_DIFFERENT	2

// Definitions used by the check key ring functions.
//..................................................
DWORD			dwCheckWhat;
DWORD			dwN1Offset;
DWORD			dwN1Bytes;
DWORD			dwN1Bits;
DWORD			dwE1Bits;
DWORD			dwP1Bits;
DWORD			dwQ1Bits;
LPBYTE			lpNextPacketPointer;
LPBYTE			lpKeyLegitPointer;
LPBYTE			lpPacketPointer;
LPBYTE			lpKeyTrustPointer;
LPBYTE			lpSigTrustPointer;
LPBYTE			lpSigPointer;
LPBYTE			lpKeyPointer;
LPBYTE			lpUserIdPointer;
LPBYTE			lpMD5Pointer;
LPBYTE			lpEncAddress;
DWORD			dwNumberOfTrustPackets;
DWORD			dwNumberOfOtherPackets;
LARGE_INTEGER	liOurTimestamp;
LARGE_INTEGER	liSigTimestamp;
LARGE_INTEGER	liCompTimestamp;
BYTE			MD5Digest[MD5_DIGEST_SIZE];
DWORD			dwKeyLength;
DWORD			dwUserIdLength;
DWORD			dwMD5Length;
DWORD			dwRSAIntBits;
DWORD			dwRSAIntBytes;
DWORD			dwHaveCompromiseSig;

// Trust table for computing keylegit values.
//...........................................
BYTE			TrustTable[8];
DWORD			dwCompletesMinimum;
DWORD			dwMarginalsMinimum;
DWORD			dwTrustCount;
BOOL			bHaveUserId;
BOOL			bKeySelfSigned = FALSE;
BOOL			bIsSelfSigned = FALSE;
BOOL			bKeyDisabled = FALSE;
BOOL			bSigByDisabled = FALSE;
BOOL			bPacketsEdited = FALSE;
BOOL			bPacketsDeleted = FALSE;
BOOL			bBuckStopSet = FALSE;
BYTE			ReasonDisabled;		// Can be V or C.
BYTE			MD5Byte1;
BYTE			MD5Byte2;
BYTE			PreviousPacket;
BYTE			TypeSignature;
BYTE			CurrentPacket;
BYTE			FirstPacket;
BYTE			SecondPacket;
BYTE			CurrentKeyId[8];
BYTE			TypeKey;
BYTE			TempUserId[256];
BYTE			TempSigId[256];
BYTE			TempOwnerId[256];
LPTSTR			NoUserId = "No User ID";

HANDLE			hDlgModeLess2;

// Variable for help topic in a dialog box.
//.........................................
DWORD			dwOldHelpTopic;

// Get current pass phrase message for message box
// if no pass phrase entered. Can come from check
// or view.
//................................................
UINT			uiGetPassPhraseMsg;

// Perform comprehensive checks on the public and secret key rings.
//.................................................................
BOOL CheckOutTheKeyRings(BOOL bProcessRunning, HWND hParentWindow)
{
	int			iDlgResult;
	DWORD		dwOldTopicNumber;
	BOOL		bLoaded;
	BOOL		bRemovehHook;
	BOOL		bRemoveMouseHook;
	BOOL		bResult = FALSE;

	dwCheckWhat = CHECK_LOADED;

	// Setup the Help Topic Number for this procedure.
	//................................................
	dwOldTopicNumber = ChangeHelpTopic(IDH_CHECKKEYRINGS);

	if (!bProcessRunning)
	{
		// We have a process in progress.
		//...............................
		bProcessInProgress = TRUE;

		// See if we want to check the currently loaded set
		// or a different set. We only do this if not called
		// from a running process like generate keys.
		//..................................................
		iDlgResult = DialogBox(hInst,TEXT("ASKCHECKKEYRINGS"),hParentWindow,
							  (DLGPROC)AskCheckKeyRings);

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iDlgResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto CheckEnd;
		}
		// See if we cancelled out of the procedure.
		//..........................................
		if (iDlgResult == IDCANCEL)
		{
			goto CheckEnd;
		}
		// If we elected to load a different set of key rings,
		// load them here. We have to do our own indexing.
		//....................................................
		if (dwCheckWhat == CHECK_DIFFERENT)
		{
			// If we have a set of key rings already loaded we have to 
			// close them.
			//........................................................
			bResult = CloseAllKeyRingFiles();
			if (!bResult)
			{	
				goto CheckEnd;
			}			

			bLoaded = LoadASetOfKeyRings(TRUE,TRUE,hParentWindow);
			
			if (!bLoaded)
			{
				goto CheckEnd;
			}
			// Index the key ring files.
			//..........................
			bResult = IndexKeyRingFiles(hParentWindow);
			if (!bResult)
			{
				goto CheckEnd;
			}
			// If we have six active key ring and index files, enable
			// the menu items.
			//.......................................................
			if (dwKeyRingFilesActive == 6)
			{
				bKeyRingFilesLoaded = TRUE;
				EnableAllMenuItems(TRUE);
				KeyRingsForStatusBar();
			}
		}
	}
	if (BPC())
	{
		goto CheckEnd;
	}
	// If we do not have six active files we have to quit.
	//....................................................
	if (dwKeyRingFilesActive != 6)
	{
		goto CheckEnd;
	}
	// Allocate memory for key buffers 1, 2,and 3.
	//............................................
	lpKeyBuffer1 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer2 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer3 = AllocateMemory(SIZE_KEY_BUFF);
	if (!lpKeyBuffer1 || !lpKeyBuffer2 || !lpKeyBuffer3)
	{
		goto CheckEnd;
	}
	// Setup the groups we will be using. Secret key ring first.
	//..........................................................
	SetUpGroup(SECRET_KEY,INDEX_KEY,GROUP_ONE);

	// Setup public key ring file. Use the key id for the index
	// for matching purposes.
	//.........................................................
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_TWO);

	// Flush and rewind all the files.
	//................................
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto CheckEnd;
	}
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto CheckEnd;
	}
	// Setup mouse and keyboard hook procedures for this dialog box
	// so you cannot tab to the checkboxes.
	//.............................................................
	bRemovehHook = FALSE;
	bRemoveMouseHook = FALSE;
	if (!hHook)
	{
		hHook = SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)TrapTabKey,NULL,0);
		bRemovehHook = TRUE;
	}
	if (!hMouseHook)
	{
		hMouseHook = SetWindowsHookEx(WH_MOUSE,(HOOKPROC)TrapMouseInput,NULL,0);
		bRemoveMouseHook = TRUE;
	}
	// Display the modeless dialog box for indexing the key rings.
	//............................................................
	hDlgModeLess2 = CreateDialog(hInst,TEXT("CHECKKEYRINGS"),hParentWindow,
								(DLGPROC)CheckKeyRingsProc);

	if (!hDlgModeLess2)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto CheckEnd;
	}
	EnableWindow(GetDlgItem(hDlgModeLess2,IDC_SECRETINTEGRITY),TRUE);

	// Check the secret key ring.
	//...........................
	TypeKey = SECRET_KEY;
	bResult = CheckTheSecretKeyRing();
	if (!bResult)
	{
		goto CheckEnd;
	}
	CheckDlgButton(hDlgModeLess2,IDC_SECRETINTEGRITY,BST_CHECKED);

	EmptyTheMessageQue();

	// See if we have to reindex the key rings.
	//.........................................
	if (dwSecretDeleted || dwPublicDeleted)
	{
		bResult = IndexKeyRingFiles(hDlgModeLess2);
		if (!bResult)
		{
			goto CheckEnd;
		}
		dwSecretDeleted = 0;
		dwPublicDeleted = 0;
	}
	// Setup for checking the public key ring. Set public key to
	// use group one and secret key for group 2.
	//..........................................................
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_ONE);
	SetUpGroup(SECRET_KEY,INDEX_KEY,GROUP_TWO);

	// Flush and rewind all the files.
	//................................
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto CheckEnd;
	}
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto CheckEnd;
	}

	EmptyTheMessageQue();

	// Check the public key ring. bResult is the result returned to
	// the calling program.
	//.............................................................
	EnableWindow(GetDlgItem(hDlgModeLess2,IDC_PUBLICINTEGRITY),TRUE);
	TypeKey = PUBLIC_KEY;
	bResult = CheckThePublicKeyRing();

	EmptyTheMessageQue();

	// Put in a small delay for small files.
	//......................................
	Sleep(1000);

	// Cleanup after ourselves. First remove our hooks.
	//.................................................
	CheckEnd:

	FlashMyIcon(FALSE);

	if (dwKeyRingFilesActive != 6)
	{
		CloseAllKeyRingFiles();
		bResult = FALSE;
		SetLastError(IDS_MISSINGKEYORINDEXFILE);
		ErrorProcedure(lpszNA,IDS_CHECKKEYRINGS,MB_OK);
	}
	// Clear all the variables we used.
	//.................................
	ClearAllVariables();
	ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));

	if (bRemovehHook)
	{
		UnhookWindowsHookEx(hHook);
		hHook = 0;
	}
	if (bRemoveMouseHook)
	{
		UnhookWindowsHookEx(hMouseHook);
		hMouseHook = 0;
	}
	if (hDlgModeLess2)
	{
		DestroyWindow(hDlgModeLess2);
	}
	ChangeHelpTopic(dwOldTopicNumber);

	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	if (lpKeyBuffer3)
	{
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer3);
		lpKeyBuffer3 = 0;
	}
	if (!bProcessRunning)
	{
		bProcessInProgress = FALSE;
	}
	return(bResult);
}

// Check the secret key ring. Returns FALSE if error.
//...................................................
BOOL CheckTheSecretKeyRing()
{
	LARGE_INTEGER	li;
	DWORD			dwBytesRead;
	DWORD			dwCtb_Byte;
	DWORD			dwSecretKeyLength;
	DWORD			dwBytesToEncipher;
	DWORD			dwCheckSum;
	DWORD			dwCompareResult;
	BOOL			bFinalResult = FALSE;
	BOOL			bResult;
	int				iDlgResult;

	while(TRUE)
	{
		EmptyTheMessageQue();
		ZeroMemory(&Prime_P,MAX_PRIME_SLOP);
		ZeroMemory(&Prime_Q,MAX_PRIME_SLOP);
		ZeroMemory(&Modulus_N,MAX_MOD_SLOP);
		ZeroMemory(&Temp1,(MAX_MOD_SLOP*2));
		ZeroMemory(&TempUserId,sizeof(TempUserId));
		
		lpKeyBufferDup1 = lpKeyBuffer1;

		// Read the index file to get the location of the first
		// secret key we will check.
		//.....................................................
		dwBytesRead = ReadIndex1();
		if (dwBytesRead == -1)
		{
			goto CheckSecretEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Read the secret key.
		//.....................
		dwBytesRead = ReadRecord1();
		if (dwBytesRead == -1)
		{
			goto CheckSecretEnd;
		}

		EmptyTheMessageQue();

		// Check out the secret key.
		//..........................
		__asm
		{
			mov		edi,lpKeyBuffer1
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			cmp		al,CTB_SECRET_KEY
			je		L1
		}
		// The key ring is possibly corrupt.
		//..................................
	  CorruptSecretKeyRing:
		SetLastError(IDS_CORRUPTSECRETKEYRING);
		ErrorProcedure((LPTSTR)&cfg.szSecretKeyRing,IDS_CHECKKEYRINGS,MB_OK);
		goto CheckSecretEnd;

		// Get the packet length.
		//.......................
	L1:	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			push	eax
			add		eax,edx
			add		eax,CTB_SIZE
			mov		dwSecretKeyLength,eax
			add		edi,edx
			pop		eax

			// Lets get our user id.
			//......................
			push	edi
			add		edi,eax
			mov		al,byte ptr [edi]
			mov		cl,al
			and		al,CTB_MASK

			// Error if first packet after secret key is not
			// a user id.
			//..............................................
			cmp		al,CTB_USER_ID
			je		L2
			pop		edi
			jmp		CorruptSecretKeyRing

			// Valid user id.
			//...............
		L2:	mov		lpKeyBufferDup1,edi
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		esi,lpKeyBufferDup1
			add		esi,CTB_SIZE
			add		esi,edx
			cmp		eax,MAX_USER_ID
			jbe		L3
			mov		eax,MAX_USER_ID
		L3:	mov		edi,offset TempUserId
			mov		ecx,eax
			rep		movsb

			// Get back the original buffer pointer. Points to
			// first byte after length field.
			//................................................
			pop		edi

			// See if the secret key is too large.
			//....................................
			cmp		dwSecretKeyLength,MAX_SECKEY_SIZE
			jbe		L4
		}
		// The secret key length is too long. We cannot handle it.
		//........................................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_OVERMAXKEYSIGSIZE,IDS_DELETEKEY,
					   MB_ICONINFORMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
			// Check out the version number.
			//..............................
		L4:	cmp		byte ptr [edi],VERSION_OLD
			je		L5
			cmp		byte ptr [edi],VERSION_NEW
			je		L5
		}
	  DeleteError:
		bResult = MarkKey1(DELETE_IT);

		if (!bResult)
		{
			goto CheckSecretEnd;
		}
		// Go and do the next record.
		//...........................
		goto GetNextKey;

		__asm
		{
			// Check the algorithm byte to make sure it is RSA.
			//.................................................
		L5:	add		edi,(VERSION_SIZE+TIMESTAMP_SIZE+VALIDITY_SIZE)
			mov		al,byte ptr [edi]
			and		al,0x01
			cmp		al,RSA_ALGORITHM
			je		L6
		}
		// The secret key is not RSA. We cannot handle it.
		//................................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_NONRSAALGORITHM,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
			// Check out Modulus n and exponent e.
			//....................................
		L6:	add		edi,ALGORITHM_SIZE
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			mov		dwN1Offset,edi
			xchg	ah,al
			mov		dwN1Bits,eax
			add		eax,7
			shr		eax,3
			mov		dwN1Bytes,eax
			jnz		L7
		}
		// MPI length of 0 encountered.
		//.............................
	  MpiError:
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_MPILENGTHZERO,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
		L7:	cmp		eax,MAX_MOD_BYTES
			jbe		L8
		}
		// Modulus n greater than 16,384 bits.
		//...................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_MODULUSNGT16384,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
		L8:	cmp		dwN1Bits,MIN_BITS
			jae		L9
		}
		// Modulus n less than 480 bits.
		//..............................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_MODULUSNLT480,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
			// Save Modulus n.
			//................
		L9:	push	eax
			push	edi
			push	edi
			pop		esi
			mov		dwN_Bytes,eax
			mov		edi,offset Modulus_N
			mov		ecx,eax
			rep		movsb
			pop		edi
			pop		eax
			add		edi,eax

			// Get and save the 8 byte key id for our search for
			// a matching key on the public key ring.
			//..................................................
			sub		edi,KEY_ID_SIZE
			mov		eax,dword ptr [edi]
			mov		edx,dword ptr [edi+4]
			mov		dword ptr KeySID,eax
			mov		dword ptr KeySID[4],edx
			add		edi,KEY_ID_SIZE

			// Check out exponent e.
			//......................
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			xchg	ah,al
			mov		dwE1Bits,eax
			add		eax,7
			shr		eax,3
			jz		MpiError
			cmp		eax,MAX_E_BYTES
			jbe		L10
		}
		// Modulus e greater than 64 bits.
		//................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_EXPONENTEGT64,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	   L10:	add		edi,eax
			inc		edi			// Get past cipher algorithm byte.

			// Check the enciphering algorithm to see if we
			// can handle it.
			//.............................................
			cmp		byte ptr [edi-1],NO_ENCRYPTION
			je		L11
			cmp		byte ptr [edi-1],TSC_ALGORITHM
			je		L11
		}
		// Unknown algorithm used to hide secret key.
		//...........................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_UNKNOWNALGORITHM,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
			// Decipher the secret key components if we have to.
			//..................................................
	   L11:	cmp		byte ptr [edi-1],TSC_ALGORITHM
			mov		lpEncAddress,edi
			jne		CheckRestOfKey
			add		edi,CFB_LENGTH
			mov		lpEncAddress,edi
			
			// Length of encipherd secret components equals total
			// length of secret key minus the offset of the first
			// byte of the secret components. This includes MPI
			// prefixes and checksum.
			//...................................................
			mov		eax,lpKeyBuffer1
			add		eax,dwSecretKeyLength
			sub		eax,edi
			mov		dwBytesToEncipher,eax
		}
		// Get the current pass phrase to decipher the secret
		// components with.
		//...................................................
		CopyMemory(lpKeyBuffer3,lpKeyBuffer1,SIZE_KEY_BUFF);
		uiGetPassPhraseMsg = IDS_NOCHECKOLDPP;

		while(TRUE)
		{
			EmptyTheMessageQue();

			UnhookWindowsHookEx(hMouseHook);
			UnhookWindowsHookEx(hHook);

			FlashMyIcon(FALSE);

			iDlgResult = DialogBox(hInst,TEXT("GETCURRENTPASSPHRASESKIP"),hMainWindow,
								  (DLGPROC)GetCurrentPassPhraseProc);

			hMouseHook = SetWindowsHookEx(WH_MOUSE,(HOOKPROC)TrapMouseInput,NULL,0);
			hHook = SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)TrapTabKey,NULL,0);

			// See if we had a system error in creating the dialog box.
			//.........................................................
			if (iDlgResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto CheckSecretEnd;
			}
			// If we did not enter a pass phrase go and check to see
			// if we have a matching public key.
			//......................................................
			if (iDlgResult == IDCANCEL)
			{
				goto MatchPublicKey;
			}

			EmptyTheMessageQue();

			// We entered a pass phrase, see if it is the right one.
			//......................................................
			DecipherSecretComponents((LPBYTE)&szPassPhrase1,lpEncAddress,iLengthOfPassPhrase,
									  dwBytesToEncipher);

			// Do the checksum on the secret components.
			//..........................................
			dwCheckSum = CheckSum(lpEncAddress,(dwBytesToEncipher-2));

			__asm
			{
				mov		edi,lpEncAddress
				mov		ebx,dwBytesToEncipher
				sub		ebx,2
				movzx	eax,word ptr [edi][ebx]
				xchg	ah,al
				mov		edx,dwCheckSum
				cmp		eax,edx
				je		CheckRestOfKey
			}
			// An invalid pass phrase was entered. Say so.
			//............................................
			CopyMemory(lpKeyBuffer1,lpKeyBuffer3,SIZE_KEY_BUFF);
			MessageBoxProc(hDlgModeLess2,IDS_INPUT_ERROR,IDS_INVALIDCHECKPP,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		}
		// We had a valid pass phrase, check the rest of the key.
		// Or the secret components were not encrypted.
		//.......................................................
		CheckRestOfKey:
		__asm
		{
			mov		edi,lpEncAddress
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			xchg	ah,al
			cmp		eax,dwN1Bits
			jbe		L12
		}
		// Exponent d is greater than Modulus n.
		//......................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_EXPDGTMODULUSN,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	   L12:	add		eax,7
			shr		eax,3
			jz		MpiError
			add		edi,eax

			// Check out prime p.
			//...................
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			xchg	ah,al
			mov		dwP1Bits,eax
			cmp		eax,(MAX_BITS/2)
			jbe		L13
		}
		// Prime p greater than 8192 bits.
		//.................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_PRIMEPGT8192,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	   L13:	add		eax,7
			shr		eax,3
			jz		MpiError

			// Save prime p.
			//..............
			push	eax
			push	edi
			push	edi
			mov		dwP_Bytes,eax
			pop		esi
			mov		ecx,eax
			mov		edi,offset Prime_P
			rep		movsb
			pop		edi
			pop		eax
			add		edi,eax

			// Check out prime q.
			//...................
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			xchg	ah,al
			mov		dwQ1Bits,eax
			cmp		eax,MAX_PRIME_BITS
			jbe		L14
		}
		// Prime q greater than 8,224 bits.
		//.................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_PRIMEQGT8224,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	   L14:	add		eax,7
			shr		eax,3
			jz		MpiError

			// Save prime q.
			//..............
			push	eax
			push	edi
			push	edi
			mov		dwQ_Bytes,eax
			pop		esi
			mov		ecx,eax
			mov		edi,offset Prime_Q
			rep		movsb
			pop		edi
			pop		eax
			add		edi,eax

			// Check out inverse u.
			//.....................
			movzx	eax,word ptr [edi]
			xchg	ah,al
			cmp		eax,dwQ1Bits
			jbe		L15
		}
		// Inverse u greater than prime q.
		//................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_INVERSEUGTPRIMEQ,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	   L15:	add		eax,7
			shr		eax,3
			jz		MpiError
		}

		EmptyTheMessageQue();

		// Circle swap primes p and q, and modulus n.
		//...........................................
		CircleSwap(&Prime_P,dwP_Bytes);
		CircleSwap(&Prime_Q,dwQ_Bytes);
		CircleSwap(&Modulus_N,dwN_Bytes);

		// The difference between primes p and q cannot exceed
		// MAX_SEP_BITS currently set at 64.
		//....................................................
		__asm
		{
			mov		eax,dwQ1Bits
			sub		eax,dwP1Bits
			jns		L16
		}
		// Prime p is greater than prime q.
		//.................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_PRIMEPGTEPRIMEQ,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	   L16:	cmp		eax,MAX_SEP_BITS
			jbe		L17
		}
		// Difference between primes p and q greater than 64 bits.
		//........................................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_DIFFPQGT64,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);	
		goto DeleteError;

		__asm
		{
			// If the bit count is equal do an actual comparison
			// of primes p and q.
			//..................................................
	   L17:	cmp		eax,0h
			jne		L18
		}
		dwCompareResult = MpCompareDW(&Prime_Q,&Prime_P,MAX_PRIME_DWORD);
		if (dwCompareResult != -1)
		{
			// Prime p is greater than or equal to prime q..
			//..............................................
			CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_PRIMEPGTEPRIMEQ,
						   IDS_DELETEKEY,MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);	
			goto DeleteError;
		}

	  L18:
		// Multiply prime p times prime q to see if they equal
		// modulus n.
		//....................................................
		CountBBD(&Prime_P,MAX_PRIME_SLOP);
		dwP_Dwords = dwCountDwords;
		CountBBD(&Prime_Q,MAX_PRIME_SLOP);
		dwQ_Dwords = dwCountDwords;
		MpMultDW(&Temp1,&Prime_Q,&Prime_P,dwQ_Dwords,dwP_Dwords);
		dwCompareResult = MpCompareDW(&Temp1,&Modulus_N,MAX_MOD_DWORD);
		if (dwCompareResult != 0)
		{
			// Prime p times prime q not equal to modulus n.
			//..............................................
			CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_PTIMESQNEMODULUSN,
						   IDS_KEYTAMPERING,MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);	
			goto DeleteError;
		}

		// If we did not enter a pass phrase we come here to see if
		// we have a matching public key. We also fall through to
		// here from checking out the secret components.
		//.........................................................
	  MatchPublicKey:

		li.QuadPart = SearchMyFileBinary(lpIndexFile2,&KeySID,KEY_ID_SIZE,hIdxHandle2,
										 0,&KeyIdSearch);
		if (li.QuadPart == -1)
		{
			goto CheckSecretEnd;
		}
		// No matching public key.
		//........................
		if (li.QuadPart == 0)
		{
			CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_MATCHPUBKEYNOTFOUND,
						   IDS_CANTCHECKSIGS,MB_ICONEXCLAMATION | MB_OK,
						   MB_ICONINFORMATION,0);
			goto CheckUserIds;
		}
		// We had a match. Go and get the public key.
		//...........................................
		dwIdxOffset2 = li.HighPart;
		dwBytesRead = ReadIndex2();
		if (dwBytesRead == -1 || dwBytesRead == 0)
		{
			goto CheckSecretEnd;
		}

		dwBytesRead = ReadRecord2();
		if (dwBytesRead == -1 || dwBytesRead == 0)
		{
			goto CheckSecretEnd;
		}
		// Got to modulus n in the public key.
		//....................................
		__asm
		{
			mov		edi,lpKeyBuffer2
			mov		lpKeyBufferDup2,edi
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			cmp		al,CTB_PUBLIC_KEY
			je		L19
		}
		// We have a malformed or corrupt public key ring.
		//................................................
		SetLastError(IDS_CORRUPTPUBLICKEYRING);
		ErrorProcedure((LPTSTR)&cfg.szPublicKeyRing,IDS_CHECKKEYRINGS,MB_OK);
		goto CheckSecretEnd;

		// Get the packet length.
		//......................
	   L19: 
		GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup2
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,(VERSION_SIZE+TIMESTAMP_SIZE+VALIDITY_SIZE+ALGORITHM_SIZE)
			movzx	eax,word ptr [edi]
			xchg	ah,al
			add		edi,MPI_PREFIX_SIZE
			cmp		eax,dwN1Bits
			je		L20
		}
		// Modulus n in public and secret keys do not match.
		//..................................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_MODNINPUBSECDIFF,
					   IDS_KEYTAMPERING,MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);	
		goto DeleteError;

		__asm
		{
			// Do an actual comparison of the modulus n in the
			// secret and public keys.
			//................................................
	   L20:	mov		ecx,dwN1Bits
			add		ecx,31
			shr		ecx,5
			mov		dwCountDwords,ecx
			mov		lpKeyBufferDup2,edi
			mov		eax,dwN1Offset
			mov		lpKeyBufferDup1,eax
		}
		dwCompareResult = MpCompareDW(lpKeyBufferDup1,lpKeyBufferDup2,dwCountDwords);
		if (dwCompareResult != 0)
		{
			// Modulus n in public and secret keys do not match.
			//..................................................
			CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_MODNINPUBSECDIFF,
						   IDS_KEYTAMPERING,MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);	
			goto DeleteError;
		}
		// Check out the user ids on the secret key.
		//..........................................
	  CheckUserIds:
		__asm
		{
			mov		edi,lpKeyBuffer1
			add		edi,dwSecretKeyLength
	   L21:	mov		al,byte ptr [edi]
			mov		lpKeyBufferDup1,edi

			// Check for end of the key.
			//..........................
			cmp		al,0h
			je		GetNextKey
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			cmp		al,CTB_USER_ID
			je		L22
		}
		// Unexpected or unknown packet in secret key.
		//............................................
		CheckEditError(IDS_CHECKSECRETKEY,TempUserId,NULL,IDS_UNKNOWNPKTINSECKEY,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		// Get the packet length.
		//.......................
	   L22:	
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			jmp		L21
		}
		// We are done checking this key. Go and get the next one.
		//........................................................
		__asm
		{
	  GetNextKey:
			mov		eax,dwIdxSize1
			add		dwIdxOffset1,eax
		}
		// Clear any pass phrase entered.
		//...............................
		ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
	}

	bFinalResult = TRUE;

	CheckSecretEnd:
	return(bFinalResult);
}

// Check the public key ring. Returns FALSE if error.
//...................................................
BOOL CheckThePublicKeyRing()
{
	LARGE_INTEGER	li;
	LARGE_INTEGER	liCurrentTimestamp;
	LARGE_INTEGER	liTempTimestamp;
	DWORD			dwTempValidityPeriod;
	DWORD			dwBytesRead;
	DWORD			dwCompareResult;
	DWORD			dwCtb_Byte;
	DWORD			dwPublicKeyLength;
	DWORD			dwTempEAX;
	DWORD			dwTempEDI;
	BOOL			bResult;
	BOOL			bFinalResult = FALSE;
	BYTE			TempBL;
	BYTE			TempTrustByte;
	BYTE			TypeDigest;

	// First do the key ring integrity check.
	//.......................................
	while(TRUE)
	{
		ZeroMemory(&TempUserId,sizeof(TempUserId));
		bHaveUserId = FALSE;
		bPacketsEdited = FALSE;
		bPacketsDeleted = FALSE;
		dwHaveCompromiseSig = 0;
		bBuckStopSet = FALSE;
		dwNumberOfTrustPackets = 0;
		dwNumberOfOtherPackets = 0;

		EmptyTheMessageQue();

		// Read the first record in the index file for the public key.
		//............................................................
		dwBytesRead = ReadIndex1();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Read the public key.
		//.....................
		dwBytesRead = ReadRecord1();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Check the key out.
		//...................
		__asm
		{
			mov		edi,lpKeyBuffer1
			mov		lpKeyBufferDup1,edi
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			cmp		al,CTB_PUBLIC_KEY
			je		L1
		}
		// The key ring is possibly corrupt.
		//..................................
		SetLastError(IDS_CORRUPTPUBLICKEYRING);
		ErrorProcedure((LPTSTR)&cfg.szPublicKeyRing,IDS_CHECKKEYRINGS,MB_OK);
		goto CheckPublicEnd;

	L1:	PreviousPacket = KEY_PACKET;
		dwNumberOfOtherPackets++;

		// Get the packet length.
		//.......................
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			push	eax
			add		eax,edx
			add		eax,CTB_SIZE
			mov		dwPublicKeyLength,eax
			add		edi,edx
			pop		eax

			// Lets get our user id.
			//......................
			push	edi
			add		edi,eax
		L2:	mov		al,byte ptr [edi]
			cmp		al,0
			jne		L3
			pop		edi
		}
		// End of key and no user id.
		//...........................
		CheckEditError(IDS_CHECKPUBLICKEY,NoUserId,NULL,IDS_PUBKEYWITHOUTID,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
	  DeleteError:
		bResult = MarkKey1(DELETE_IT);
		if (!bResult)
		{
			goto CheckPublicEnd;
		}
		// Go and do the next record.
		//...........................
		goto GetNextKey;

		__asm
		{
		L3:	mov		cl,al
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
			and		al,CTB_MASK
			cmp		al,CTB_USER_ID
			je		L4
		}
		// Not a user id.
		//...............
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			jmp		L2

			// We have our user id.
			//.....................
		}
		L4:	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			cmp		eax,MAX_USER_ID
			jbe		L5
			mov		eax,MAX_USER_ID
		L5:	mov		esi,edi
			mov		ecx,eax
			mov		edi,offset TempUserId
			rep		movsb
			
			// We have our user id.
			//.....................
			pop		edi

			// See if the key is too large.
			//.............................
			cmp		dwPublicKeyLength,MAX_PUBKEY_SIZE
			jbe		L6
		}
		// The public key is too large to handle.
		//.......................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,IDS_OVERMAXKEYSIGSIZE,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		// Check out the version number.
		//..............................
		__asm
		{
		L6:	cmp		byte ptr [edi],VERSION_OLD
			je		L7
			cmp		byte ptr [edi],VERSION_NEW
			je		L7
		}
		// Unsupported version encountered.
		//.................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,IDS_UNSUPPORTEDVERSION,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
		L7:	add		edi,(VERSION_SIZE+TIMESTAMP_SIZE+VALIDITY_SIZE)
			mov		al,byte ptr [edi]
			and		al,0x01
			cmp		al,RSA_ALGORITHM
			je		L8
		}
		// Non RSA algorithm encountered.
		//...............................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,IDS_NONRSAALGORITHM,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
			// Check out modulus n and exponent e.
			//....................................
		L8:	add		edi,ALGORITHM_SIZE
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			xchg	ah,al
			mov		dwN1Bits,eax
			add		eax,7
			shr		eax,3
			jnz		L9
		}
	  MpiError:
		// Mpi length of 0 found.
		//.......................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,IDS_MPILENGTHZERO,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
		L9:	cmp		eax,MAX_MOD_BYTES
			jbe		L10
		}
		// Modulus n greater than 16,384 bits.
		//...................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,IDS_MODULUSNGT16384,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	   L10:	cmp		dwN1Bits,MIN_BITS
			jae		L11
		}
		// Modulus n less than 480 bits.
		//..............................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,IDS_MODULUSNLT480,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	   L11:	add		edi,eax

			// Get and save the 8 byte key id for our search for a
			// matching key on the secret key ring.
			//....................................................
			sub		edi,KEY_ID_SIZE
			mov		eax,dword ptr [edi]
			mov		edx,dword ptr [edi+4]
			mov		dword ptr KeySID,eax
			mov		dword ptr KeySID[4],edx
			add		edi,KEY_ID_SIZE

			// Check out exponent e.
			//......................
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			xchg	ah,al
			add		eax,7
			shr		eax,3
			jz		MpiError
			cmp		eax,MAX_E_BYTES
			jbe		L12
		}
		// Exponent e greater than 64 bits.
		//.................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,IDS_EXPONENTEGT64,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	   L12:	add		edi,eax

			// Check out the packets after the key. We need the
			// first and second packet types.
			//.................................................
			push	edi
			mov		al,byte ptr [edi]
			and		al,CTB_MASK
			mov		cl,al
			mov		FirstPacket,al
			mov		lpKeyBufferDup1,edi
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		al,byte ptr [edi]
			and		al,CTB_MASK
			mov		SecondPacket,al
			pop		edi

			// Process the packets one at a time.
			//...................................
	   L13:	mov		al,byte ptr [edi]

			// Check for end of key.
			//......................
			cmp		al,0h
			je		CheckNumberOfPackets
			mov		lpPacketPointer,edi
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		lpKeyBufferDup1,edi
			push	eax
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpNextPacketPointer,edi
			add		lpNextPacketPointer,eax
			pop		ecx

			// Entry: eax = packet length, cl = packet type,
			// edx = length of length field, edi = first byte
			// after CTB and length bytes.
			//...............................................
			cmp		cl,CTB_SKE_PACKET
			jne		CheckForTrustPacket

			// We have a signature packet.
			//............................
			mov		esi,MAX_SIG_SIZE
			sub		esi,3
			cmp		eax,esi
			jbe		L14
		}
		// Maximum signature size exceeded.
		//.................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,IDS_OVERMAXKEYSIGSIZE,
					   IDS_DELETESIGNATURE,MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeletePacket;

		__asm
		{
	   L14:	push	edi

			// We have to get the type before we can determine if the
			// signature is ok and in the right place.
			//.......................................................
			add		edi,(VERSION_SIZE+1)
			cmp		byte ptr [edi],KEY_COMPROMISE
			jne		L15
			mov		CurrentPacket,COMP_PACKET
			inc		dwHaveCompromiseSig
			jmp		L17
	   L15:	cmp		byte ptr [edi],KEY_CERT_GEN
			jb		L16
			cmp		byte ptr [edi],KEY_CERT_SELF
			ja		L16
			mov		CurrentPacket,SIG_PACKET
			inc		dwNumberOfOtherPackets
			jmp		L17
	   L16:	pop		edi
		}
		// Maximum signature size exceeded.
		//.................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_UNKNOWNSIGINPUBKEY,IDS_DELETESIGNATURE,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeletePacket;

		__asm
		{
	   L17:	pop		edi

			// Check out the version.
			//.......................
			cmp		byte ptr [edi],VERSION_OLD
			je		L18
			cmp		byte ptr [edi],VERSION_NEW
			je		L18
		}
		// Unsupported version in signature.
		//..................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_UNSUPPORTEDVERSION,IDS_DELETESIGNATURE,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);		
	  DeletePacket:
		MarkPacket1();

		__asm
		{
			mov		al,CurrentPacket
			mov		PreviousPacket,al
			mov		edi,lpNextPacketPointer
			jmp		L13

			// Check out the rest of the key.
			//...............................
	   L18:	add		edi,VERSION_SIZE

			// Check out the md5 or sha append length.
			//........................................
			cmp		byte ptr [edi],SKE_APPEND_LGTH
			je		L19
			cmp		byte ptr [edi],SKE_SHA_APPEND_LGTH
			je		L19
		}
		// Append length not 5 or 14, unsupported version.
		//.......................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_UNSUPPORTEDVERSION,IDS_DELETESIGNATURE,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeletePacket;

		__asm
		{
	   L19:	add		edi,(2+TIMESTAMP_SIZE)

			// If this is a compromise certificate make sure the 
			// key id matches the public key id.
			//..................................................
			cmp		CurrentPacket,COMP_PACKET
			jne		L21
			mov		eax,dword ptr [edi]
			mov		edx,dword ptr [edi+4]
			cmp		eax,dword ptr KeySID
			jne		L20
			cmp		edx,dword ptr KeySID[4]
			je		L21
	   L20:	
		}
		// Key ids do not match.
		//......................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,IDS_KEYIDSNOMATCH,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	   L21:	add		edi,KEY_ID_SIZE

			// Must be RSA algorithm.
			//.......................
			mov		al,byte ptr [edi]
			and		al,0x01
			cmp		al,RSA_ALGORITHM
			je		L22
		}
		// Unsupported version in signature.
		//..................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_UNSUPPORTEDVERSION,IDS_DELETESIGNATURE,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeletePacket;

		__asm
		{
	   L22:	add		edi,ALGORITHM_SIZE

			// Must be Md5, Sha1, or Sha512 algorithm.
			//........................................
			cmp		byte ptr [edi],MD5_ALGORITHM
			je		L23
			cmp		byte ptr [edi],SHA_ALGORITHM
			je		L23
			cmp		byte ptr [edi],SHA512_ALGORITHM
			je		L23
		}
		// Unsupported version in signature.
		//..................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_NONMD5ALGORITHM,IDS_DELETESIGNATURE,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeletePacket;

		__asm
		{
			// If we have a signature right after the key, it must
			// be a compromise signature.
			//....................................................
	   L23:	cmp		FirstPacket,CTB_TRUST
			jne		L24
			cmp		SecondPacket,CTB_SKE_PACKET
			jne		L24
			cmp		CurrentPacket,COMP_PACKET
			je		L24
		}
		// Signature right after key not a compromise certificate.
		//........................................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_SIGAFTERKEYNOTCOMP,IDS_DELETESIGNATURE,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeletePacket;

		__asm
		{
			// Disable the previous check. Following signatures
			// will pass through.
			//.................................................
	   L24:	mov		SecondPacket,0

			// More than one compromise signature in key?
			//...........................................
			cmp		CurrentPacket,COMP_PACKET
			jne		L25
			cmp		dwHaveCompromiseSig,1
			jbe		L25
		}
		// More than one compromise signature in key.
		//...........................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_MORETHANONECOMPSIG,IDS_DELETESIGNATURE,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeletePacket;

		__asm
		{
			// Compromise signature does not immediately follow
			// key packet?
			//.................................................
	   L25:	cmp		bHaveUserId,TRUE
			jne		L26
			cmp		CurrentPacket,COMP_PACKET
			jne		L26
		}
		// Compromise certificate does not immediately follow
		// the key packet.
		//...................................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_SIGPKTNOTAFTERKEY,IDS_DELETESIGNATURE,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeletePacket;

		__asm
		{
			// A signature packet must always follow a trust packet.
			//......................................................
	   L26:	cmp		CurrentPacket,SIG_PACKET
			jne		ProcessRestOfKey
			cmp		PreviousPacket,TRUST_PCKT
			je		ProcessRestOfKey
		}
		// Packets not in proper order on key ring.
		//.........................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_PCKTSNOTPROPERORDER,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	  CheckForTrustPacket:
			cmp		cl,CTB_TRUST
			jne		CheckForUserId
			mov		CurrentPacket,TRUST_PCKT
			inc		dwNumberOfTrustPackets
			mov		al,byte ptr [edi]
			cmp		PreviousPacket,KEY_PACKET
			jne		L27
			mov		lpKeyTrustPointer,edi
			test	al,BUCKSTOP_BIT
			jz		L27
			mov		bBuckStopSet,TRUE
	   L27:	cmp		PreviousPacket,KEY_PACKET
			je		ProcessRestOfKey
			cmp		PreviousPacket,USER_ID_PACKET
			je		ProcessRestOfKey
			cmp		PreviousPacket,SIG_PACKET
			je		ProcessRestOfKey
		}
		// Packets not in proper order on key ring.
		//.........................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_PCKTSNOTPROPERORDER,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	  CheckForUserId:
			cmp		cl,CTB_USER_ID
			jne		UnknownPacket
			mov		CurrentPacket,USER_ID_PACKET
			inc		dwNumberOfOtherPackets
			mov		bHaveUserId,TRUE

			// Save the user id in case there is more than
			// one in the key.
			//............................................
			push	edi
			push	eax
		}
		ZeroMemory(&TempUserId,sizeof(TempUserId));

		__asm
		{
			pop		ecx
			pop		esi
			cmp		ecx,MAX_USER_ID
			jbe		L28
			mov		ecx,MAX_USER_ID
	   L28:	mov		edi,offset TempUserId
			rep		movsb

			// A user id can only follow a trust packet or
			// compromise certificate.
			//............................................
			cmp		PreviousPacket,TRUST_PCKT
			je		ProcessRestOfKey
			cmp		PreviousPacket,COMP_PACKET
			je		ProcessRestOfKey
		}
		// Packets not in proper order on key ring.
		//.........................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_PCKTSNOTPROPERORDER,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		__asm
		{
	  UnknownPacket:
			mov		CurrentPacket,UNKN_PACKET
		}
		// Unknown or unwanted packet in public key.
		//..........................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_UNKNOWNPKTINPUBKEY,IDS_DELETEPACKET,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeletePacket;

		__asm
		{
			// Process the rest of the key.
			//.............................
	  ProcessRestOfKey:
			mov		al,CurrentPacket
			mov		PreviousPacket,al
			mov		edi,lpNextPacketPointer
			jmp		L13

			// See if we have the correct number of trust packets
			// and other packets. They must match.
			//...................................................
	  CheckNumberOfPackets:
			mov		eax,dwNumberOfTrustPackets
			cmp		eax,dwNumberOfOtherPackets
			je		MatchSecretKey
		}
		// Number of trust packets not equal to the other packets.
		//........................................................
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,
					   IDS_NOTRUSTPKTSNOTEQUAL,IDS_DELETEKEY,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
		goto DeleteError;

		// See if we have a matching secret key. If the buckstop
		// bit is set and we have a match OK. If the buckstop bit
		// is set and no match, say so. If match and no buckstop
		// bit set we have to set the buckstop bit.
		//.......................................................
	  MatchSecretKey:
		li.QuadPart = SearchMyFileBinary(lpIndexFile2,&KeySID,KEY_ID_SIZE,hIdxHandle2,
										 0,&KeyIdSearch);
		if (li.QuadPart == -1)
		{
			goto CheckPublicEnd;
		}
		// No matching secret key and the buckstop bit is set.
		// Say we are missing the secret key. Reset the trust
		// byte to always trust to sign.
		//...................................................
		if (li.QuadPart == 0)
		{
			if (bBuckStopSet)
			{
				CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,NULL,IDS_MATCHSECKEYNOTFOUND,
							   IDS_CANTDECIPHERENCPCKT,MB_ICONINFORMATION | MB_OK,
							   MB_ICONINFORMATION,0);
				__asm
				{
					mov		edi,lpKeyTrustPointer
					mov		byte ptr [edi],COMPLETE_TRUST
					mov		bPacketsEdited,TRUE
				}
			}
		}
		else
		{
			// We had a match. If buckstop bit is not set we have 
			// to set it. All other checks will have been made by
			// the check secret key procedure.
			//...................................................
			if (!bBuckStopSet)
			{
				__asm
				{
					mov		edi,lpKeyTrustPointer
					or		byte ptr [edi],BUCKSTOP_BIT
					or		byte ptr [edi],ON_SECRET_RING
					mov		bPacketsEdited,TRUE
				}
			}
		}
		// If we had packets deleted or edited, we have to write the
		// key back to disk to make sure the changes take.
		//..........................................................
		if (bPacketsDeleted || bPacketsEdited)
		{
			bResult = WriteRecord1();
			if (!bResult)
			{
				goto CheckPublicEnd;
			}
			if (bPacketsDeleted)
			{
				dwPublicDeleted++;
			}
		}
		// We are done checking this key. Go and get the next one.
		//........................................................
		__asm
		{
	  GetNextKey:
			mov		eax,dwIdxSize1
			add		dwIdxOffset1,eax
		}
	}	// while(TRUE)

	// No errors in the integrity check.
	//..................................
	CheckDlgButton(hDlgModeLess2,IDC_PUBLICINTEGRITY,BST_CHECKED);

	// If we had packets or keys deleted, we have to re-index.
	//........................................................
	if (dwPublicDeleted)
	{
		bResult = IndexKeyRingFiles(hDlgModeLess2);
		if (!bResult)
		{
			goto CheckPublicEnd;
		}
		dwPublicDeleted = 0;
	}
	// Check the signatures on each public key.
	//.........................................
	EnableWindow(GetDlgItem(hDlgModeLess2,IDC_KEYSIGNATURES),TRUE);

	// Rewind and flush all the files.
	//................................
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto CheckPublicEnd;
	}
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto CheckPublicEnd;
	}
	// The public key ring is set for group 1. Set it to group 2
	// also so we can find the public keys for signatures. All of 
	// our integrity checks have been made so we can sail through
	// the next set of checks.
	//...........................................................
	dwIdxOffset1 = 0;
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_ONE);
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_TWO);

	EmptyTheMessageQue();

	while(TRUE)
	{
		dwKeyLength = 0;
		dwUserIdLength = 0;
		dwMD5Length = 0;
		bPacketsDeleted = FALSE;
		bPacketsEdited = FALSE;
		bKeySelfSigned = FALSE;
		bKeyDisabled = FALSE;
		ReasonDisabled = 0;
		ZeroMemory(&TempSigId,sizeof(TempSigId));

		// Read the index file.
		//.....................
		dwBytesRead = ReadIndex1();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Read the public key.
		//.....................
		dwBytesRead = ReadRecord1();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Get the key id from the index file. Used for checking
		// for self signed keys.
		//......................................................
		__asm
		{
			mov		edi,lpIdxBuffer1
			mov		eax,dword ptr [edi]K_IDX_FMT.KEY_ID
			mov		edx,dword ptr [edi+4]K_IDX_FMT.KEY_ID
			mov		dword ptr CurrentKeyId,eax
			mov		dword ptr CurrentKeyId[4],edx

			// The first packet is the key packet. Contary to
			// what it says in the documentation, we use the CTB
			// and length field of the key packet when checking
			// and making signatures.
			//..................................................
			mov		edi,lpKeyBuffer1
			mov		lpKeyPointer,edi
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBuffer1,dwCtb_Byte);

		// Setup for the timestamp.
		//.........................
		liOurTimestamp.QuadPart = 0;

		__asm
		{
			mov		edi,lpKeyBuffer1
			add		edi,CTB_SIZE
			add		edi,edx

			// Get the timestamp and the validity period.
			//...........................................
			push	edi
			push	eax
			add		edi,VERSION_SIZE
			mov		eax,dword ptr [edi]
			bswap	eax
			mov		liOurTimestamp.LowPart,eax

			// Get the high 7 bits of the timestamp.
			//......................................
			mov		eax,dword ptr [edi+6]
			and		eax,0x00ff
			shr		eax,1
			mov		liOurTimestamp.HighPart,eax

			add		edi,TIMESTAMP_SIZE
			movzx	eax,word ptr [edi]
			xchg	ah,al
			mov		dwValidityPeriod,eax
			pop		eax
			pop		edi
			add		edi,eax
			mov		dwKeyLength,edi
			mov		edx,lpKeyBuffer1
			sub		dwKeyLength,edx

			// The second is the trust packet.
			//................................
			mov		cl,byte ptr [edi]
			mov		lpKeyBufferDup1,edi
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpKeyTrustPointer,edi
			add		edi,eax

			// We can now have one compromise certificate and
			// multiple ids and sigs, or no sigs at all.
			//...............................................
	   L29:	mov		al,byte ptr [edi]
			cmp		al,0h
			je		DoneCheckingTheKey
			mov		lpPacketPointer,edi
			mov		cl,al
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
			and		al,CTB_MASK

			// If we have a user id set up its pointer and length.
			//....................................................
			cmp		al,CTB_USER_ID
			jne		CheckCTBTrust
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			mov		dwUserIdLength,eax
			add		edi,edx
			mov		lpNextPacketPointer,edi
			add		lpNextPacketPointer,eax
			mov		lpUserIdPointer,edi
			push	eax
			push	edi
		}
		ZeroMemory(&TempUserId,sizeof(TempUserId));

		__asm
		{
			pop		esi
			pop		ecx
			cmp		ecx,MAX_USER_ID
			jbe		L30
			mov		ecx,MAX_USER_ID
	   L30:	mov		edi,offset TempUserId
			rep		movsb
			jmp		CheckTheNextPacket

			// Skip the trust bytes. Sig trust bytes will be
			// taken care of with their signatures.
			//..............................................
		  CheckCTBTrust:
			cmp		al,CTB_TRUST
			jne		CheckSignatures
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		lpNextPacketPointer,edi
			jmp		CheckTheNextPacket

			// Signature can be a compromise or reqular signature.
			//....................................................
		  CheckSignatures:
			cmp		al,CTB_SKE_PACKET
			jne		CheckTheNextPacket
			mov		bSigByDisabled,FALSE
			mov		bIsSelfSigned,FALSE
		}
		// Set comp sig timestamp to 0.
		//.............................
		liCompTimestamp.QuadPart = 0;

		// Clear all the variables for key generation.
		//............................................
		ClearAllVariables();

		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpNextPacketPointer,edi
			add		lpNextPacketPointer,eax

			// Get a pointer to the sig trust byte.
			//.....................................
			push	edi
			mov		edi,lpNextPacketPointer
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		liSigTimestamp.QuadPart = 0;
		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpSigTrustPointer,edi
			pop		edi

			// Get the length of the Md5 or Sha material to append to
			// the message digest calculations.
			//.......................................................
			add		edi,VERSION_SIZE
			movzx	eax,byte ptr [edi]
			mov		dwMD5Length,eax
			inc		edi

			// Get the type of signature, compromise or regular.
			//..................................................
			mov		al,byte ptr [edi]
			mov		TypeSignature,al
			mov		lpMD5Pointer,edi

			// Get the signature timestamp to check against
			// the public key.
			//.............................................
			inc		edi
			mov		eax,dword ptr [edi]
			bswap	eax
			mov		liSigTimestamp.LowPart,eax

			// Get the high 7 bits of the timestamp.
			//......................................
			mov		eax,dword ptr [edi+12]
			and		eax,0x00ff
			shr		eax,1
			mov		liSigTimestamp.HighPart,eax

			add		edi,TIMESTAMP_SIZE

			// Get the key id so we can find the public key to
			// decrypt the rsa integer with.
			//................................................
			mov		eax,dword ptr [edi]
			mov		edx,dword ptr [edi+4]
			mov		dword ptr KeySID,eax
			mov		dword ptr KeySID[4],edx
			add		edi,(KEY_ID_SIZE+ALGORITHM_SIZE)

			// Get the type of digest, md5, Sha1, or Sha512.
			//..............................................
			mov		al,byte ptr [edi]
			mov		TypeDigest,al
			add		edi,ALGORITHM_SIZE

			// Get the first two bytes of the message digest.
			// Used to check to see if we had the right key.
			//...............................................
			mov		al,byte ptr [edi]
			mov		dl,byte ptr [edi+1]
			mov		MD5Byte1,al
			mov		MD5Byte2,dl
			add		edi,2

			// Transfer the rsa integer to decrypt to Temp1.
			//..............................................
			movzx	eax,word ptr [edi]
			xchg	ah,al
			mov		dwRSAIntBits,eax
			add		eax,7
			shr		eax,3
			mov		dwRSAIntBytes,eax
			add		edi,MPI_PREFIX_SIZE
			mov		esi,edi
			mov		ecx,eax
			mov		edi,offset Temp1
			rep		movsb
		}
		CircleSwap(&Temp1,dwRSAIntBytes);

		__asm
		{
			// Check to see if this is a self signature.
			//..........................................
			mov		eax,dword ptr CurrentKeyId
			mov		edx,dword ptr CurrentKeyId[4]
			cmp		eax,dword ptr KeySID
			jne		L31
			cmp		edx,dword ptr KeySID[4]
			jne		L31
			mov		bIsSelfSigned,TRUE
			inc		bKeySelfSigned
	   L31:
		}
		if (TypeDigest == MD5_ALGORITHM)
		{
			// Perform the MD5 calculation on the key or key and
			// user id.
			//..................................................
			Md5Initialize(&Md5Context);
			Md5Update(&Md5Context,lpKeyPointer,dwKeyLength);
			if (TypeSignature != KEY_COMPROMISE && dwUserIdLength > 0)
			{
				Md5Update(&Md5Context,lpUserIdPointer,dwUserIdLength);
			}
			Md5Update(&Md5Context,lpMD5Pointer,dwMD5Length);
			Md5Final((LPBYTE)&MD5Digest,&Md5Context);
		}
		else if (TypeDigest == SHA_ALGORITHM)
		{
			// Perform the Sha1 calculation on the key or key and
			// user id.
			//...................................................
			ShaInit(&ShaContext);
			ShaUpdate(&ShaContext,lpKeyPointer,dwKeyLength);
			if (TypeSignature != KEY_COMPROMISE && dwUserIdLength > 0)
			{
				ShaUpdate(&ShaContext,lpUserIdPointer,dwUserIdLength);
			}
			ShaUpdate(&ShaContext,lpMD5Pointer,dwMD5Length);
			ShaFinal(&ShaDigest,&ShaContext);

		}
		else
		{
			// Perform the Sha512 calculation on the key or key and
			// user id.
			//......................................................
			sha512_begin(&Sha512Context);
			sha512_hash(lpKeyPointer,dwKeyLength,&Sha512Context);
			if (TypeSignature != KEY_COMPROMISE && dwUserIdLength > 0)
			{
				sha512_hash(lpUserIdPointer,dwUserIdLength,&Sha512Context);
			}
			sha512_hash(lpMD5Pointer,dwMD5Length,&Sha512Context);
			sha512_end(&Sha512Digest,&Sha512Context);
		}
		// Search for the public key to decrypt the signature with.
		//.........................................................
		li.QuadPart = SearchMyFileBinary(lpIndexFile2,&KeySID,KEY_ID_SIZE,hIdxHandle2,
										 0,&KeyIdSearch);
		if (li.QuadPart == -1)
		{
			goto CheckPublicEnd;
		}
		// If we did not have a match make sure the checked bit is
		// not set and the sigtrust bits get set to unknown owner.
		//.........................................................
		if (li.QuadPart == 0)
		{
			__asm
			{
				mov		edi,lpSigTrustPointer
				xor		al,al
				or		al,UNKNOWN_OWNER
				mov		byte ptr [edi],al
				mov		bPacketsEdited,TRUE
			}
			if (bIsSelfSigned)
			{
				bKeySelfSigned--;
			}
			goto CheckTheNextPacket;
		}
		// We had a match. Read the key and decrypt the rsa integer.
		//..........................................................
		dwIdxOffset2 = li.HighPart;
		dwBytesRead = ReadIndex2();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		dwBytesRead = ReadRecord2();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Setup modulus n and exponent e for the decryption.
		// Check to make sure than modulus n is greater than
		// the rsa integer to decrypt.
		//...................................................
		__asm
		{
			mov		edi,lpKeyBuffer2
			mov		cl,byte ptr [edi]
			mov		lpKeyBufferDup2,edi
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup2
			add		edi,CTB_SIZE
			add		edi,edx
			push	edi
			add		edi,eax

			// Get the sig user id for display in the error dialog box.
			//.........................................................
	   L32:	mov		al,byte ptr [edi]
			mov		cl,al
			and		al,CTB_MASK
			mov		TempBL,al
			mov		lpKeyBufferDup2,edi
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup2
			add		edi,CTB_SIZE
			add		edi,edx
			cmp		TempBL,CTB_USER_ID
			jne		CheckSigPacket
			push	edi
			push	eax
		}
		ZeroMemory(&TempSigId,sizeof(TempSigId));

		__asm
		{
			pop		ecx
			pop		esi
			cmp		ecx,MAX_USER_ID
			jbe		L33
			mov		ecx,MAX_USER_ID
	   L33:	mov		edi,offset TempSigId
			rep		movsb
		}
		// If the signature is a compromise signature, make 
		// the user id equal to the sig id.
		//.................................................
		if (TypeSignature == KEY_COMPROMISE)
		{
			CopyMemory(TempUserId,TempSigId,MAX_USER_ID);
		}
		goto CheckTimestamp;

	  CheckSigPacket:

		__asm
		{
			// Only type of signature before user id is a compromise
			// certificate. Get the timestamp of the compromise sig.
			//......................................................
			cmp		TempBL,CTB_SKE_PACKET
			jne		UserIdContinue
			push	edi
			push	eax
			add		edi,3
			mov		edx,dword ptr [edi]
			bswap	edx
			mov		liCompTimestamp.LowPart,edx

			// Get the high order 7 bits of the timestamp.
			//............................................
			mov		eax,dword ptr [edi+12]
			and		eax,0x00ff
			shr		eax,1
			mov		liCompTimestamp.HighPart,eax

			pop		eax
			pop		edi
			add		edi,eax
			jmp		L32
		  UserIdContinue:
			add		edi,eax
			jmp		L32
		}

	  CheckTimestamp:

		// Setup a temp timestamp variable.
		//.................................
		liTempTimestamp.QuadPart = 0;
		__asm
		{
			pop		edi

			// Check the timestamp and validity period of the public
			// key that made the signature to make sure it is still
			// valid.
			//......................................................
			add		edi,VERSION_SIZE
			mov		esi,dword ptr [edi]
			bswap	esi
			mov		liTempTimestamp.LowPart,esi

			// Get the high order 7 bits of the timestamp.
			//............................................
			mov		eax,dword ptr [edi+6]
			and		eax,0x00ff
			shr		eax,1
			mov		liTempTimestamp.HighPart,eax

			add		edi,TIMESTAMP_SIZE
			mov		dwTempEDI,edi
			movzx	eax,word ptr [edi]
			xchg	ah,al
			mov		dwTempValidityPeriod,eax
		}
		if (liCompTimestamp.QuadPart == 0)
		{
			if (dwTempValidityPeriod)
			{
				__asm
				{
					xor		edx,edx
					mov		eax,dwTempValidityPeriod
					mov		ecx,SECS_PER_DAY
					mul		ecx
					add		liTempTimestamp.LowPart,eax
					adc		liTempTimestamp.HighPart,edx
				}
				liCompTimestamp.QuadPart = liTempTimestamp.QuadPart;
			}
		}
		// If the signature timestamp is greater than comp
		// timestamp the signature was made by a disabled
		// public key.
		//................................................
		if (liCompTimestamp.QuadPart != 0)
		{
			if (liSigTimestamp.QuadPart > liCompTimestamp.QuadPart)
			{
				bSigByDisabled = TRUE;
			}
		}
		// Make sure modulus n is greater than the rsa integer.
		//.....................................................
		__asm
		{
			mov		edi,dwTempEDI
			add		edi,(VALIDITY_SIZE+ALGORITHM_SIZE)
			movzx	eax,word ptr [edi]
			xchg	ah,al
			cmp		eax,dwRSAIntBits
			jae		L36
		}
		// Invalid or corrupt signature encountered.
		//..........................................
	  SignatureError:
		CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,TempSigId,
					   IDS_INVALIDSIGNATURE,IDS_DELETESIGNATURE,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,NULL);
		MarkPacket1();
		if (bIsSelfSigned)
		{
			bKeySelfSigned--;
		}
		goto CheckTheNextPacket;

		__asm
		{
			// Transfer modulus n to memory.
			//..............................
	   L36:	add		eax,7
			shr		eax,3
			add		edi,MPI_PREFIX_SIZE
			push	edi
			push	eax
			mov		dwTempEAX,eax
			mov		esi,edi
			mov		ecx,eax
			mov		edi,offset Modulus_N
			rep		movsb
		}
		CircleSwap(&Modulus_N,dwTempEAX);

		__asm
		{
			pop		eax
			pop		edi
			add		edi,eax
			mov		dwN1Bytes,eax

			// Now transfer exponent e.
			//.........................
			movzx	eax,word ptr [edi]
			xchg	ah,al
			add		edi,MPI_PREFIX_SIZE
			add		eax,7
			shr		eax,3
			mov		dwTempEAX,eax
			mov		esi,edi
			mov		ecx,eax
			mov		edi,offset E_Temp
			rep		movsb
		}
		CircleSwap(&E_Temp,dwTempEAX);

		// Make sure that the rsa integer in Temp1 is less than
		// modulus n.
		//.....................................................
		dwCompareResult = MpCompareDW(&Temp1,&Modulus_N,MAX_MOD_DWORD);
		if (dwCompareResult != 1)
		{
			goto SignatureError;
		}
		// Decrypt the signature.
		//.......................
		RsaPubDec(&Temp2,&Temp1,&E_Temp,&Modulus_N,dwN1Bytes);

		// If dwCountBytes is not equal to the size of an Md5, Sha1, or Sha512
		// message digest we have an error.
		//....................................................................
		if (dwCountBytes != MD5_DIGEST_SIZE && dwCountBytes != SHA_DIGEST_SIZE &&
			dwCountBytes != SHA512_DIGEST_SIZE)
		{
			goto SignatureError;
		}
		// Compare the first two bytes returned in Temp2 with
		// the Md5Bytes to see if they are the same.
		//...................................................
		__asm
		{
			mov		edi,offset Temp2
			mov		al,byte ptr [edi]
			mov		dl,byte ptr [edi+1]
			cmp		al,MD5Byte1
			jne		SignatureError
			cmp		dl,MD5Byte2
			jne		SignatureError

			// Compare the decrypted Md5, Sha1, or Sha512 digest with the one
			// we calculated.
			//...............................................................
			mov		esi,offset Temp2
			mov		edi,offset MD5Digest
			cmp		dwCountBytes,MD5_DIGEST_SIZE
			je		L37A
			mov		edi,offset ShaDigest
			cmp		dwCountBytes,SHA_DIGEST_SIZE
			je		L37A
			mov		edi,offset Sha512Digest
	  L37A: mov		ecx,dwCountBytes
			repe	cmpsb
			jnz		SignatureError

			// We have a good signature. Set the checked and self
			// signed bits, if required, in the sigtrust byte if
			// if is not a compromise signature.
			//...................................................
			cmp		TypeSignature,KEY_COMPROMISE
			je		WeHaveCompSig
			mov		edi,lpSigTrustPointer
			xor		al,al
			or		al,CHECKED_BIT
			cmp		bIsSelfSigned,0
			je		L37
			or		al,SELF_SIGNED_BIT
	   L37:	mov		byte ptr [edi],al
			mov		bPacketsEdited,TRUE
			jmp		L38

			// We have a compromise signature. Mark key as 
			// disabled and set the reason.
			//............................................
		  WeHaveCompSig:
			mov		bKeyDisabled,TRUE
			mov		ReasonDisabled,'C'
	   L38:
		}
		// Sound a warning if the signature was made by a disabled key.
		//.............................................................
		if (bSigByDisabled)
		{
			CheckEditError(IDS_CHECKPUBLICKEY,TempUserId,TempSigId,
						   IDS_SIGAFTERKEYDISABLED,IDS_SUSPICIOUS,
						   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,NULL);
		}
		// Check the next packet.
		//.......................
		__asm
		{
		  CheckTheNextPacket:
			mov		edi,lpNextPacketPointer
			jmp		L29
		}
	  DoneCheckingTheKey:;

		// If the key is not disabled by a compromise certificate
		// see if it is disabled by the validity period. Compromise
		// and validity could both disable a key, but compromise
		// takes precedent.
		//.........................................................
		if (!bKeyDisabled && dwValidityPeriod)
		{
			__asm
			{
				xor		edx,edx
				mov		eax,dwValidityPeriod
				mov		ecx,SECS_PER_DAY
				mul		ecx
				add		liOurTimestamp.LowPart,eax
				adc		liOurTimestamp.HighPart,edx
			}
			liCurrentTimestamp.QuadPart = GetTimestamp(TRUE);
			if (liCurrentTimestamp.QuadPart > liOurTimestamp.QuadPart)
			{
				__asm
				{
					mov		bKeyDisabled,TRUE
					mov		ReasonDisabled,'V'
				}
			}
		}
		// Set or reset the selfsig bit in the ownertrust byte. If
		// the key has become disabled set that bit too, and the
		// reason why. Once a key is permanently disabled it can
		// never be enabled again. We do not change the owner trust
		// bits. If you want to do it, do it from the edit procedure.
		//...........................................................
		__asm
		{
			mov		edi,lpKeyTrustPointer
			mov		al,byte ptr [edi]
			cmp		bKeySelfSigned,0
			je		L39
			or		al,SELF_SIGNED_BIT
			jmp		L40
	   L39:	and		al, not SELF_SIGNED_BIT
	   L40:	cmp		bKeyDisabled,0h
			je		L42
			or		al,DISABLED_BIT
			cmp		ReasonDisabled,0h
			je		L42
			cmp		ReasonDisabled,'V'
			jne		L41
			or		al,WHY_DISABLED
			jmp		L42
	   L41:	and		al,not WHY_DISABLED
	   L42:	mov		byte ptr [edi],al
			mov		bPacketsEdited,TRUE
		}
		// If we had packets deleted or edited we have to write the
		// key back to disk to make sure the changes take.
		//.........................................................
		if (bPacketsDeleted || bPacketsEdited)
		{
			bResult = WriteRecord1();
			if (!bResult)
			{
				goto CheckPublicEnd;
			}
			if (bPacketsDeleted)
			{
				dwPublicDeleted++;
			}
		}
		// Read the next index file record.
		//.................................
		__asm
		{
			mov		eax,dwIdxSize1
			add		dwIdxOffset1,eax
		}
	}	// while(TRUE)

	// We are done checking signatures. No errors.
	//............................................
	CheckDlgButton(hDlgModeLess2,IDC_KEYSIGNATURES,BST_CHECKED);

	// See if we have to reindex the key rings.
	//.........................................
	if (dwPublicDeleted)
	{
		bResult = IndexKeyRingFiles(hDlgModeLess2);
		if (!bResult)
		{
			goto CheckPublicEnd;
		}
		dwPublicDeleted = 0;
	}
	// Check the owner trust packets of each public key.
	//..................................................
	EnableWindow(GetDlgItem(hDlgModeLess2,IDC_OWNERTRUSTPCKT),TRUE);

	// Rewind and flush all the files.
	//................................
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto CheckPublicEnd;
	}
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto CheckPublicEnd;
	}
	// Reset the index file pointer.
	//..............................
	dwIdxOffset1 = 0;

	// Read in the keys one at a time a see if we need to set the
	// owner trust packet. Will ask if owner trust is not initialized.
	//................................................................
	while(TRUE)
	{
		ZeroMemory(&TempOwnerId,sizeof(TempOwnerId));
		
		dwBytesRead = ReadIndex1();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Read the public key.
		//.....................
		dwBytesRead = ReadRecord1();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}

		EmptyTheMessageQue();

		// Goto the owner trust packet and see if we need to set it.
		//..........................................................
		__asm
		{
			mov		edi,lpKeyBuffer1
			mov		cl,byte ptr [edi]
			mov		lpKeyBufferDup1,edi
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov 	al,byte ptr [edi]
			and		al,OWNER_SIG_MASK
			cmp		al,NOT_INITIALIZED
			jne		ReadNextIndexRecord
		}
		bResult = SetTheOwnerTrustByte(SET_OWNER_TRUST);
		if (!bResult)
		{
			goto CheckPublicEnd;
		}

		__asm
		{
		  ReadNextIndexRecord:
			mov		eax,dwIdxSize1
			add		dwIdxOffset1,eax
		}
	}
	// No errors while setting owner trust.
	//.....................................
	CheckDlgButton(hDlgModeLess2,IDC_OWNERTRUSTPCKT,BST_CHECKED);

	// Rewind and flush all the files.
	//................................
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto CheckPublicEnd;
	}
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto CheckPublicEnd;
	}
	// Reset the index file pointer.
	//..............................
	dwIdxOffset1 = 0;

	bPacketsEdited = FALSE;

	// Set the signature trust packets.
	//.................................
	EnableWindow(GetDlgItem(hDlgModeLess2,IDC_SIGTRUSTPCKT),TRUE);

	// Read in the keys one at a time and set the sigtrust for all
	// the signatures in the keys.
	//............................................................
	while(TRUE)
	{
		EmptyTheMessageQue();

		dwBytesRead = ReadIndex1();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Check for end of file. Done setting sigtrust packets.
		//......................................................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Read the public key.
		//.....................
		dwBytesRead = ReadRecord1();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Search for the signatures in the key. All other packets
		// can be skiped.
		//........................................................
		__asm
		{
			mov		edi,lpKeyBuffer1
	   L43:	mov		al,byte ptr [edi]

			// Check for end of the key.
			//..........................
			cmp		al,0h
			je		L46
			mov		cl,al
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
			and		al,CTB_MASK

			// Skip all packets except signature packets.
			//...........................................
			cmp		al,CTB_SKE_PACKET
			je		L44
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		lpNextPacketPointer,edi
			jmp		L45

			// We have a signature packet. Get the signing key and
			// set the sigtrust equal to the owner trust.
			//....................................................
		  L44:
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpNextPacketPointer,edi
			add		lpNextPacketPointer,eax
			
			// Get a pointer to the sigtrust byte.
			//....................................
			push	edi
			mov		edi,lpNextPacketPointer
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpSigTrustPointer,edi
			pop		edi

			// If the type of signature is a key compromise we
			// skip it. No sigtrust on key compromise certificate.
			//....................................................
			add		edi,(VERSION_SIZE+1)
			cmp		byte ptr [edi],KEY_COMPROMISE
			je		L45

			// Get the key id so we can find the public key to
			// copy the owner trust packet to the sigtrust packet.
			//....................................................
			add		edi,(1+TIMESTAMP_SIZE)
			mov		eax,dword ptr [edi]
			mov		edx,dword ptr [edi+4]
			mov		dword ptr KeySID,eax
			mov		dword ptr KeySID[4],edx
		}
		// Search for the public key owner of the signature.
		//..................................................
		li.QuadPart = SearchMyFileBinary(lpIndexFile2,&KeySID,KEY_ID_SIZE,hIdxHandle2,
										 0,&KeyIdSearch);
		if (li.QuadPart == -1)
		{
			goto CheckPublicEnd;
		}
		// If we did not have a match the sigtrust packet is 
		// already set to what we want it to be.
		//..................................................
		if (li.QuadPart == 0)
		{
			goto L45;
		}
		// We had a match. Read the key and extract the owner
		// trust packet.
		//...................................................
		dwIdxOffset2 = li.HighPart;
		dwBytesRead = ReadIndex2();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Read the key.
		//..............
		dwBytesRead = ReadRecord2();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// The signature's key is now in lpKeyBuffer2.
		// Get the owner trust byte.
		//............................................
		__asm
		{
			mov		edi,lpKeyBuffer2
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup2,edi
		}
		GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup2
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup2,edi
		}
		GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup2
			add		edi,CTB_SIZE
			add		edi,edx
			mov		al,byte ptr [edi]
			and		al,OWNER_SIG_MASK

			// Set the sigtrust packet equal to the owner
			// trust packet.
			//...........................................
			mov		edi,lpSigTrustPointer
			and		byte ptr [edi],not OWNER_SIG_MASK
			or		byte ptr [edi],al
			mov		bPacketsEdited,TRUE
			
			// Continue checking this key.
			//............................
	   L45:	mov		edi,lpNextPacketPointer
			jmp		L43

			// We are at the end of the key.
			//..............................
	   L46:
		}
		// If we changed any packets write the key back to disk.
		//......................................................
		if (bPacketsEdited)
		{
			bResult = WriteRecord1();
			if (!bResult)
			{
				goto CheckPublicEnd;
			}
			bPacketsEdited = FALSE;
		}
		// Setup to get the next index file record.
		//.........................................
		__asm
		{
			mov		eax,dwIdxSize1
			add		dwIdxOffset1,eax
		}
	}	// while(TRUE)
	
	// No errors while setting sigtrust.
	//..................................
	CheckDlgButton(hDlgModeLess2,IDC_SIGTRUSTPCKT,BST_CHECKED);

	// Rewind and flush all the files.
	//................................
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto CheckPublicEnd;
	}
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto CheckPublicEnd;
	}

	EmptyTheMessageQue();

	// Reset the index file pointer.
	//..............................
	dwIdxOffset1 = 0;

	// Initialize the trust table for computing trust.
	//................................................
	InitializeTrustTable();

	// Set the signature trust packets.
	//.................................
	EnableWindow(GetDlgItem(hDlgModeLess2,IDC_LEGITTRUSTPCKT),TRUE);

	// Read in the keys one at a time and set the keylegit trust
	// byte for all the user ids in the keys.
	//..........................................................
	while(TRUE)
	{
		EmptyTheMessageQue();
		bBuckStopSet = FALSE;

		dwBytesRead = ReadIndex1();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Check for end of file. Done setting keylegit packets.
		//......................................................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Read the public key.
		//.....................
		dwBytesRead = ReadRecord1();
		if (dwBytesRead == -1)
		{
			goto CheckPublicEnd;
		}
		// Get past the key packet and owner trust packet.
		//................................................
		__asm
		{
			mov		edi,lpKeyBuffer1
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx

			// If the buckstop bit is set this is our own key.
			//................................................
			test	byte ptr [edi],BUCKSTOP_BIT
			jz		L47
			mov		bBuckStopSet,TRUE
	   L47:	add		edi,eax

			// Now look for user ids and set their keylegit packets
			// to reflect the buckstop bit or the sigs that follow it.
			//........................................................
	   L48:	mov		al,byte ptr [edi]
		
			// Check for end of the key.
			//..........................
			cmp		al,0h
			je		L56
			mov		cl,al
			and		al,CTB_MASK
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi

			// Skip all packets except user id packets. This will
			// skip the compromise certificate right after the
			// trust byte for the key since we are looking for the
			// first user id.
			//....................................................
			cmp		al,CTB_USER_ID
			je		L49
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		lpNextPacketPointer,edi
			jmp		L55

			// We have a user id. Get a pointer to the keylegit byte.
			//.......................................................
	   L49:
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpKeyLegitPointer,edi
			add		edi,eax
			mov		lpNextPacketPointer,edi

			// If the buckstop bit is set, set the keylegit to max.
			//.....................................................
			cmp		bBuckStopSet,TRUE
			jne		L50
			mov		edi,lpKeyLegitPointer
			xor		al,al
			or		al,UID_COMPL_TRUST
			mov		byte ptr [edi],al
			jmp		L55

			// Not a buckstop key. Look at all the following
			// signatures and calculate the keylegit byte. Do
			// not count self signatures or signatures that 
			// have the checked bit reset.
			//...............................................
	   L50:	mov		dwTrustCount,0h
	   L51:	mov		al,byte ptr [edi]
			
			// Check for end of key.
			//......................
			cmp		al,0h
			je		L54
			mov		cl,al
			and		al,CTB_MASK
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi

			// Next user id in the key.
			//.........................
			cmp		al,CTB_USER_ID
			je		L54

			// We have a signature packet.
			//............................
			cmp		al,CTB_SKE_PACKET
			jne		L52
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax

			// Get the following trust packet.
			//................................
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpNextPacketPointer,edi
			add		lpNextPacketPointer,eax
			movzx	esi,byte ptr [edi]

			// We do not count self signed signatures or 
			// signatures that do not check out.
			//..........................................
			test	esi,SELF_SIGNED_BIT
			jnz		L53
			test	esi,CHECKED_BIT
			jz		L53
			and		esi,OWNER_SIG_MASK
			movzx	eax,TrustTable[esi]
			add		dwTrustCount,eax
			jmp		L53

			// Not a signature. Setup for the next packet.
			//............................................
	   L52:
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		lpNextPacketPointer,edi

			// Get the next packet.
			//....................
	   L53:	mov		edi,lpNextPacketPointer
			jmp		L51

	   L54:
		}
		// Set the keylegit trust value. Clears the warnonly bit.
		//.......................................................
		TempTrustByte = 0;
		if (dwTrustCount == 0)
		{
			TempTrustByte |= UID_UNKNOWN;
		}
		else if ( dwTrustCount < dwMarginalsMinimum)
		{
			TempTrustByte |= UID_NOT_TRUST;
		}
		else if (dwTrustCount < dwCompletesMinimum)
		{
			TempTrustByte |= UID_MARG_TRUST;
		}
		else
		{
			TempTrustByte |= UID_COMPL_TRUST;
		}
		// Set the keylegit byte.
		//.......................
		__asm
		{
			mov		edi,lpKeyLegitPointer
			mov		al,TempTrustByte
			mov		byte ptr [edi],al

			// Get the next packet.
			//.....................
	   L55: mov		edi,lpNextPacketPointer
			jmp		L48
		}
		// Write the modified key back to disk.
		//.....................................
	  L56:
		bResult = WriteRecord1();
		if (!bResult)
		{
			goto CheckPublicEnd;
		}

		__asm
		{
			// Read the next index file record.
			//.................................
			mov		eax,dwIdxSize1
			add		dwIdxOffset1,eax
		}
	}	// while(TRUE)

	// No error while setting keylegit byte.
	//......................................
	CheckDlgButton(hDlgModeLess2,IDC_LEGITTRUSTPCKT,BST_CHECKED);

	bFinalResult = TRUE;

	CheckPublicEnd:
	return(bFinalResult);
}

// CALLBACK procedure for the Check Key Rings dialog box.
//.......................................................
LRESULT CALLBACK CheckKeyRingsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	TCHAR	szOutBuff[128];

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the marginals and completes required.
			//............................................
			StringCbPrintf(szOutBuff,sizeof(szOutBuff),
					       TEXT("Completes Required: %lu      Marginals Required: %lu"),
						   cfg.dwCompletesRequired,cfg.dwMarginalsRequired);
			SetDlgItemText(hDlg,IDC_SETTINGS,szOutBuff);
			
			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_DESTROY:
		{
			hDlgModeLess1 = NULL;
		}
		break;

		case WM_CLOSE:
			break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for the AskCheckKeyRings dialog box.
//......................................................
LRESULT CALLBACK AskCheckKeyRings(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{

			// Check the default radiobutton for check loaded.
			//................................................
			CheckRadioButton(hDlg,IDC_CHECKLOADED,IDC_CHECKLOADDIFF,IDC_CHECKLOADED);
			dwCheckWhat = CHECK_LOADED;

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_CHECKLOADED:
				{
					CheckRadioButton(hDlg,IDC_CHECKLOADED,IDC_CHECKLOADDIFF,IDC_CHECKLOADED);
					dwCheckWhat = CHECK_LOADED;
				}
				break;

				case IDC_CHECKLOADDIFF:
				{
					CheckRadioButton(hDlg,IDC_CHECKLOADED,IDC_CHECKLOADDIFF,IDC_CHECKLOADDIFF);
					dwCheckWhat = CHECK_DIFFERENT;
				}
				break;

				case IDOK:
				{
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// Mark the key in key buffer 1 for deletion or undeletion
// and write the result to disk. Returns FALSE if error.
//........................................................
BOOL MarkKey1(DWORD dwOperation)
{
	BOOL	bResult;
	DWORD	dwCtb_Byte;
	DWORD	dwTempEAX;

	__asm
	{
		mov		edi,lpKeyBuffer1
	L1: mov		al,byte ptr [edi]

		// Check for end of key.
		//......................
		cmp		al,0h
		je		MarkEnd
		mov		cl,al
		mov		dwCtb_Byte,ecx
		cmp		dwOperation,DELETE_IT
		jne		L2
		bts		eax,DELETE_BIT
		jmp		L3
	L2:	btr		eax,DELETE_BIT
	L3:	mov		byte ptr [edi],al
		mov		lpKeyBufferDup1,edi
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,eax
		jmp		L1
	}
	// We are done marking the key. Now write it back to disk.
	//........................................................
	MarkEnd:
	bResult = WriteRecord1();
	if (!bResult)
	{
		goto MarkKeyEnd;
	}
	// Update public or secret key deleted variables.
	//...............................................
	if (dwOperation == DELETE_IT)
	{
		dwTempEAX = 1;
	}
	else
	{
		dwTempEAX = -1;
	}
	if (TypeKey == PUBLIC_KEY)
	{
		dwPublicDeleted += dwTempEAX;
	}
	else
	{
		dwSecretDeleted += dwTempEAX;
	}

	MarkKeyEnd:
	return(bResult);
}

// Mark a packet, and its following trust packet, if any, for deletion.
//.....................................................................
VOID MarkPacket1()
{
	__asm
	{
		mov		bPacketsDeleted,TRUE
		mov		edi,lpPacketPointer
		mov		al,byte ptr [edi]
		mov		cl,al
		bts		eax,DELETE_BIT
		mov		byte ptr [edi],al
		mov		edi,lpNextPacketPointer
		mov		al,byte ptr [edi]
		mov		cl,al
		and		cl,CTB_MASK

		// If the following packet is a trust packet, delete it.
		//......................................................
		cmp		cl,CTB_TRUST
		jne		MarkPcktEnd
		bts		eax,DELETE_BIT
		mov		byte ptr [edi],al
	MarkPcktEnd:
	}
}

// CALLBACK procedure for the enter current pass phrase dialog box.
//.................................................................
LRESULT CALLBACK GetCurrentPassPhraseProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	BYTE		AllEqual;
	int			i;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limit for the pass phrase.
			//........................................
			SendDlgItemMessage(hDlg,IDC_OLDPP,EM_SETLIMITTEXT,(WPARAM) 250,0);

			// Clear the pass phrase.
			//.......................
			ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
			iLengthOfPassPhrase = 0;
			ZeroMemory(&szTemp,sizeof(szTemp));

			// Set the current user id.
			//.........................
			SetDlgItemTextFmt(hDlg,IDC_CURRENTUID,TempUserId);

			dwOldHelpTopic = ChangeHelpTopic(IDH_GETOLDPP);

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_OLDPP));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Retrieve the pass phrase.
					//..........................
					GetDlgItemText(hDlg,IDC_OLDPP,(LPTSTR)&szTemp,sizeof(szTemp));
					iLengthOfPassPhrase = lstrlen((LPTSTR)&szTemp);

					// Inform the user that the secret components
					// will not be checked if no pass phrase.
					//...........................................
					if (iLengthOfPassPhrase == 0)
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,uiGetPassPhraseMsg,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						break;
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,iLengthOfPassPhrase
						mov		edi,offset szTemp
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (i = 0; i < iLengthOfPassPhrase; i++)
						{
							if ((BYTE)szTemp[i] != DEFAULT_CHAR)
							{
								szPassPhrase1[i] = szTemp[i];
							}
						}
					}
					// Reset the old help topic.
					//..........................
					ChangeHelpTopic(dwOldHelpTopic);
					SetDlgItemText(hDlg,IDC_OLDPP,lpszNullString);
					ZeroMemory(&szTemp,sizeof(szTemp));
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_CLEARPP:
				{
					SetDlgItemText(hDlg,IDC_OLDPP,(LPCTSTR)lpszNullString);
					ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
					SetFocus(GetDlgItem(hDlg,IDC_OLDPP));
				}
				break;

				case IDC_OLDPPTEXT:
				{
					VirtualKeyboard(hDlg,IDC_OLDPP,(LPBYTE)&szPassPhrase1,
							        sizeof(szPassPhrase1));
					SetFocus(GetDlgItem(hDlg,IDC_OLDPP));
				}
				break;

				case IDC_SKIP:
				case IDCANCEL:
				{
					// Reset the old help topic.
					//..........................
					ChangeHelpTopic(dwOldHelpTopic);
					SetDlgItemText(hDlg,IDC_OLDPP,lpszNullString);
					ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
					EndDialog(hDlg,IDCANCEL);
				}
				break;
			
				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Initialize the trust table for computing trust. It sets up the
// trust table values for computing the keyledit value from the
// signatures.
//...............................................................
VOID InitializeTrustTable()
{
	__asm
	{
		mov		eax,cfg.dwCompletesRequired
		cmp		cfg.dwMarginalsRequired,eax
		jae		L1
		mov		cfg.dwMarginalsRequired,eax
	L1:	mov		TrustTable[5],al
		mov		eax,cfg.dwMarginalsRequired
		mov		TrustTable[6],al
		mov		eax,cfg.dwCompletesRequired
		mul		cfg.dwMarginalsRequired
		mov		dwCompletesMinimum,eax
		mov		TrustTable[7],al
		shr		eax,1
		jnc		L2
		inc		eax
	L2: mov		dwMarginalsMinimum,eax
	}
}
